﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="VIRP_WEB.Controls.Custom.EFR.RelatedLabDetails" Codebehind="RelatedLabDetails.ascx.cs" %>

<asp:GridView ID = "GridViewRelatedLabDetails" runat="server" 
    DataSourceID = "ObjectDataSourceLabDetails" AutoGenerateColumns="false" AllowPaging="False"  AllowSorting = "true"  
    DataKeyNames="RELATED_LAB_TEST_ID" UseAccessibleHeader = "true" CssClass="gridRegistry">
    <EmptyDataTemplate>
        No related lab tests found for this patient 
    </EmptyDataTemplate>                     
    <Columns>
        <asp:TemplateField AccessibleHeaderText = "Result Date" HeaderText = "Result Date" >
            <ItemTemplate>
                 <asp:Label ID = "LabelResultDate" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_COMPLETE_DATE", "{0:M/d/yyyy H:mm}"))) %>' SkinID = "DataLabel" /> 
                            
            </ItemTemplate>
         </asp:TemplateField>
         
         <asp:TemplateField AccessibleHeaderText = "Date Specimen Collected" HeaderText = "Date Specimen Collected">    
            <ItemTemplate>
                <asp:Label ID = "LabelSpecimenDate" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_SPECIMEN_DATE", "{0:M/d/yyyy H:mm}"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Result" HeaderText = "Result">    
            <ItemTemplate>
                <asp:Label ID = "LabelResult" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_RESULT_VALUE"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Result Units" HeaderText = "Result Units">    
            <ItemTemplate>
                <asp:Label ID = "LabelResultUnits" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_RESULT_UNIT"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Ref Low" HeaderText = "Ref Low">    
            <ItemTemplate>
                <asp:Label ID = "LabelRefLow" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("REF_LOW"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Ref High" HeaderText = "Ref High">    
            <ItemTemplate>
                <asp:Label ID = "LabelRefHigh" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("REF_HIGH"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Abnormal Indicator" HeaderText = "Abnormal Indicator">    
            <ItemTemplate>
                <asp:Label ID = "LabelAbnormal" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ABNORMAL"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Request Site Number" HeaderText = "Request Site Number">    
            <ItemTemplate>
                <asp:Label ID = "LabelRequestSiteNumber" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("REQUESTING_FACILITY_NAME"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Result Site Number" HeaderText = "Result Site Number">    
            <ItemTemplate>
                <asp:Label ID = "LabelResultSiteNumber" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("RESULTING_FACILITY_NAME"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    

         <asp:TemplateField AccessibleHeaderText = "LOINC" HeaderText = "LOINC">    
            <ItemTemplate>
                <asp:Label ID = "LabelLOINC" runat = "server" 
                Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LONINC_CODE"))) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    

    </Columns> 
</asp:GridView> 
<asp:HiddenField runat="server" ID="HiddenFieldPatientID" />
<asp:HiddenField runat="server" ID="HiddenFieldLabName" />
<asp:HiddenField runat="server" ID="HiddenFieldSpecimenType" />

<asp:ObjectDataSource ID = "ObjectDataSourceLabDetails" runat = "server" SelectMethod="GetItemsByPatientAndLabTestAndSpecimen"  
    EnablePaging="false" TypeName="VIRP.EFR.BLL.RELATED_LAB_TESTManager" DataObjectTypeName="VIRP.EFR.BO.RelatedLabTestView">
    <SelectParameters>            
        <asp:Parameter Name="CURRENT_USER" Type="String" />
        <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
       <asp:ControlParameter ControlID="HiddenFieldPatientID"
           ConvertEmptyStringToNull = "true"  Direction="Input"  DefaultValue="0"
           Name="PATIENT_ID" Type="Int32"/>
       <asp:ControlParameter ControlID="HiddenFieldLabName"
           ConvertEmptyStringToNull = "true"  Direction="Input"  DefaultValue="0"
           Name="LAB_TEST_NAME" Type="String"/>
       <asp:ControlParameter ControlID="HiddenFieldSpecimenType"
           ConvertEmptyStringToNull = "true"  Direction="Input"  DefaultValue="0"
           Name="SPECIMEN_TYPE" Type="String"/>
    </SelectParameters>
 </asp:ObjectDataSource>     
